# Copyright (C) 2013-2023 Echelon Corporation.  All Rights Reserved.
# Use of this code is subject to your compliance with the terms of the
# Echelon IzoT(tm) Software Developer's Kit License Agreement which is
# available at www.echelon.com/license/izot_sdk/.

# IzoT resources contained in this file are generated by an automated
# database to source code conversion process.  Grammar and punctuation within
# the embedded documentation may not be correct, as this data is gathered and
# combined from several sources.
# Names of resources and fields or members defined within a resource are
# derived from the same sources.  Names, capitalization and aspects of source
# code formatting may fail to comply with PEP-8 and PEP-257 recommendations
# due to the automated generation of these IzoT definitions.
# Generated at 11-May-2023 17:11.

"""devMonTiming userdefined property type, originally defined in resource
file set apollodev 90:00:01:06:00:00:00:00-4."""


import izot.resources.base
from P9000010600000000_4.userdefined import userdefined


class devMonTiming(izot.resources.base.Structure):
    """devMonTiming userdefined property type.  ."""

    def __init__(self):
        super().__init__(
            key=22,
            scope=4
        )

        self.__recoveryTmo = izot.resources.base.Scaled(
            size=2,
            signed=True,
            minimum=1,
            maximum=32767
        )
        self._register(('recoveryTmo', self.__recoveryTmo))

        self.__msgThottle = izot.resources.base.Scaled(
            size=2,
            signed=False,
            minimum=1,
            maximum=65535
        )
        self._register(('msgThottle', self.__msgThottle))
        self._default_bytes = b'\x00\x00\x00\x00'
        self._original_name = 'UCPTdevMonTiming'
        self._property_scope, self._property_key = 4, 22
        self._definition = userdefined.add(self)

    def __set_recoveryTmo(self, v):
        self.__recoveryTmo._value = v

    recoveryTmo = property(
        lambda self: self.__recoveryTmo._value,
        __set_recoveryTmo,
        None,
        """Time delay to recover down devices.  (s)."""
    )

    def __set_msgThottle(self, v):
        self.__msgThottle._value = v

    msgThottle = property(
        lambda self: self.__msgThottle._value,
        __set_msgThottle,
        None,
        """Time delay between test requests.  (ms)."""
    )

    def __len__(self):
        """Return the length of the type, in bytes."""
        return 4


if __name__ == '__main__':
    # unit test code.
    item = devMonTiming()
    pass
